﻿#pragma once


/****************************************************************************
*  CONST DEFINE
****************************************************************************/
#define E_SUCCESS 0

//#define STATIC_DLL
//#define EXPORT_CDECL		//输出接口名不带后缀

void UnloadDll();
BOOL LoadDll();


#ifdef EXPORT_CDECL
#define CALL_STACK __cdecl
#else
#define CALL_STACK __stdcall
#endif

#ifdef __cplusplus
#define PRINTER_API extern "C" __declspec( dllimport )
#else
#define PRINTER_WIN32_SDK_API __declspec( dllimport )
#endif

/* Prtprinter */
typedef int(CALL_STACK *pPrinterCreator)(void**, const TCHAR*);
typedef void*(CALL_STACK *pPrinterCreatorS)(char*);
typedef int(CALL_STACK *pPrinterDestroy)(void*);
typedef int(CALL_STACK *pPortOpen)(void*, const TCHAR*);
typedef int(CALL_STACK *pPortClose)(void*);
typedef int(CALL_STACK *pWriteData)(void*, unsigned char[], unsigned int);
typedef int(CALL_STACK *pReadData)(void*, unsigned char[], unsigned int, unsigned int*);
typedef int(CALL_STACK *pZPL_GetPrinterDpi)(void*, char*);
typedef int(CALL_STACK *pDirectIO)(void*, unsigned char[], unsigned int, unsigned char[], unsigned int, unsigned int*);
typedef int(CALL_STACK *pGetUriOption)(void* handle, char* key, char* value, int buflen);
typedef int(CALL_STACK *pZPL_StartFormat)(void*);
typedef int(CALL_STACK *pZPL_GetPrinterStatus)(void*, int*/*unsigned char[]*/);
typedef int(CALL_STACK *pZPL_EndFormat)(void*);
typedef int(CALL_STACK *pZPL_SetChangeFontEncoding)(void*, int);
typedef int(CALL_STACK *pZPL_SetVietMode)(void*, int);
typedef int(CALL_STACK *pZPL_SetVietFontEncoding)(void*);
typedef int(CALL_STACK *pZPL_SetUserFontName)(void*, const char*);
typedef int(CALL_STACK *pZPL_Text)(void*, int, int, int, int, int, int, const char*);
typedef int(CALL_STACK *pZPL_Text_Block)(void*, int, int, int, int, int, int, int, int, const char*);
typedef int(CALL_STACK *pZPL_BarCode39)(void*, int, int, int, int, int, char, char, char, const char*);
typedef int(CALL_STACK *pZPL_Pdf417)(void*, int, int, int, int, int, int, int, int, char, const char*);
typedef int(CALL_STACK *pZPL_MicroPdf417)(void*, int, int, int, int, int, int, const char*);
typedef int(CALL_STACK *pZPL_SetLabelHome)(void*, int, int);
typedef int(CALL_STACK *pZPL_SetLabelLength)(void*, int);
typedef int(CALL_STACK *pZPL_SetTearOffAdjustPosition)(void*, int);
typedef int(CALL_STACK *pZPL_CodeEan8)(void*, int, int, int, int, int, char, char, const char*);
typedef int(CALL_STACK *pZPL_QRCode)(void*, int, int, int, int, int, char, char, char, const char*);

typedef int(CALL_STACK *pZPL_UpcExtensions)(void*, int, int, int, int, int, char, char, const char*);
typedef int(CALL_STACK *pZPL_UpcaBarcode)(void*, int, int, int, int, int, char, char, char, const char*);
typedef int(CALL_STACK *pZPL_GraphicBox)(void*, int, int, int, int, int, int);
typedef int(CALL_STACK *pZPL_GraphicCircle)(void*, int, int, int, int);
typedef int(CALL_STACK *pZPL_GraphicDiagonalLine)(void*, int, int, int, int, int, int);
typedef int(CALL_STACK *pZPL_GraphicEllipse)(void*, int, int, int, int, int);
typedef int(CALL_STACK *pZPL_PrintImage)(void*, int, int, const char*);
typedef int(CALL_STACK *pZPL_PrintImageStream)(void*, int, int, char*, int);
typedef int(CALL_STACK *pZPL_GraphicSymbol)(void*, int, int, int, int, int, const char*);
typedef int(CALL_STACK *pZPL_SetDiagnosticsMode)(void*, int);
typedef int(CALL_STACK *pZPL_SetPrintRate)(void*, int, int, int);
typedef int(CALL_STACK *pZPL_SetPrintDarkness)(void*, int);
typedef int(CALL_STACK *pZPL_PrintConfigurationLabel)(void*);
typedef int(CALL_STACK *pZPL_SetSerialCommunications)(void*, int, int, char, int, char);

typedef int(CALL_STACK *pZPL_RfidWrite)(void* handle, char format, int begin, int size, char memoryBlock, const char* text);
typedef int(CALL_STACK *pZPL_RfidRead)(void* handle, char format, int begin, int size, char memoryBlock, const char* headText, const char* tailText);
typedef int(CALL_STACK *pZPL_RfidCalibration)(void* handle);
typedef int(CALL_STACK *GetUsbList)(const TCHAR* cUsbList, int buf_size, int* pcnt, int type);
typedef int(CALL_STACK *pDownloadFontFile)(void* handle, int iPacketSize, char* filename, char* desc, void* fprogess);
typedef int(CALL_STACK *downloadYModem)(void* handle, char* filename, char* desc, void* fprogess); 
typedef int(CALL_STACK *pDownloadFMWImg)(void* handle, char* filename, char* desc, void* fprogess);
extern void	* hprinter;
extern HMODULE	m_Dll;

extern pPrinterCreator							fPrinterCreator;
extern pPrinterCreatorS							fPrinterCreatorS;
extern pPortOpen								fPortOpen;
extern pPortClose								fPortClose;
extern pWriteData								fWriteData;
extern pReadData								fReadData;
extern pPrinterDestroy							fPrinterDestroy;
extern pDirectIO								fDirectIO;
extern pGetUriOption							fGetUriOption;
extern pZPL_GetPrinterDpi						fGetPrinterDpi;
extern pZPL_StartFormat							fStartFormat;
extern pZPL_GetPrinterStatus					fGetPrinterStatus;
extern pZPL_EndFormat							fEndFormat;
extern pZPL_SetChangeFontEncoding				fSetChangeFontEncoding;
extern pZPL_SetVietMode							fSetVietMode;
extern pZPL_SetVietFontEncoding					fSetVietFontEncoding;
extern pZPL_SetUserFontName						fPrintSetUserFontName;
extern pZPL_Text								fPrintText;
extern pZPL_Text_Block							fPrintTextBlock;
extern pZPL_BarCode39							fBarCode39;
extern pZPL_Pdf417								fPdf417;
extern pZPL_MicroPdf417							fMicroPdf417;
extern pZPL_SetLabelHome						fSetLabelHome;
extern pZPL_SetLabelLength						fSetLabelLength;
extern pZPL_SetTearOffAdjustPosition			fSetTearOffAdjustPosition;
extern pZPL_CodeEan8							fCodeEan8;
extern pZPL_QRCode								fQRCode;
extern pZPL_UpcExtensions						fUpcExtensions;
extern pZPL_UpcaBarcode							fUpcaBarcode;
extern pZPL_GraphicBox							fGraphicBox;
extern pZPL_GraphicCircle						fGraphicCircle;
extern pZPL_GraphicDiagonalLine					fGraphicDiagonaline;
extern pZPL_GraphicEllipse						fGraphicEllipse;
extern pZPL_GraphicSymbol						fGraphicSymbol;
extern pZPL_PrintImage							fPrintImage;
extern pZPL_PrintImageStream					fPrintImageStream;
extern pZPL_SetDiagnosticsMode					fSetDiagnosticsMode;
extern pZPL_SetPrintRate						fSetPrintRate;
extern pZPL_SetPrintDarkness					fSetPrintDarkness;
extern pZPL_PrintConfigurationLabel				fPrintConfigurationLabel;
extern pZPL_SetSerialCommunications				fSetSerialCommunications;


extern pZPL_RfidWrite			fZPL_RfidWrite;
extern pZPL_RfidRead			fZPL_RfidRead;
extern pZPL_RfidCalibration		fZPL_RfidCalibration;
extern GetUsbList               DemGetUsbList;
extern pDownloadFontFile		fDownloadFontFile;
extern downloadYModem			DemdownloadYModem;
extern pDownloadFMWImg          fDownloadFMWImg;